<?php $__env->startSection('content'); ?>

<section class="checkout spad">
    <div class="container">

        <div class="checkout__form">
            <h4>Realize seu cadastro :) 
                <a class="btn btn-info" href="<?php echo e($rota); ?>/login">Já sou cadastrado(a)</a>
            </h4>

            <form method="post">
                <?php echo csrf_field(); ?>

                <input type="hidden" value="<?php echo e($default['config']->empresa_id); ?>" name="empresa_id">
                <input type="hidden" value="<?php echo e($default['carrinho']->id); ?>" name="pedido_id">

                <div class="row">
                    <div class="col-lg-8 col-md-6">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="checkout__input">
                                    <p>Nome<span>*</span></p>
                                    <input autofocus name="nome" value="<?php echo e(old('nome')); ?>" type="text">
                                    <?php if($errors->has('nome')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('nome')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="checkout__input">
                                    <p>Sobre nome<span>*</span></p>
                                    <input value="<?php echo e(old('sobre_nome')); ?>" name="sobre_nome" type="text">
                                    <?php if($errors->has('sobre_nome')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('sobre_nome')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="checkout__input">
                                    <p>Telefone<span>*</span></p>
                                    <input data-mask="(00) 00000-0000" value="<?php echo e(old('telefone')); ?>" name="telefone" type="text">
                                    <?php if($errors->has('telefone')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('telefone')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="checkout__input">
                                    <p>Email<span>*</span></p>
                                    <input value="<?php echo e(old('email')); ?>" name="email" type="text">
                                    <?php if($errors->has('email')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('email')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-4">
                                <div class="checkout__input">
                                    <p>Senha<span>*</span></p>
                                    <input name="senha" type="password">
                                    <?php if($errors->has('senha')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('senha')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-lg-2">
                                <div class="checkout__input">
                                    <p>Tipo Doc.<span>*</span></p>
                                    <select name="tp_doc" id="tp_doc" class="form-control" style="height: 47px;">
                                        <option <?php if(old('tp_doc') == 'cpf'): ?> selected <?php endif; ?> value="cpf">CPF</option>
                                        <option <?php if(old('tp_doc') == 'cnpj'): ?> selected <?php endif; ?> value="cnpj">CNPJ</option>
                                    </select>
                                    
                                </div>
                            </div>
                            <div class="col-lg-5">
                                <div class="checkout__input">
                                    <p class="lbl_doc">CPF<span>*</span></p>
                                    <input id="doc" value="<?php echo e(old('cpf')); ?>" data-mask="000.000.000-00" data-mask-reverse="true" name="cpf" type="text">
                                    <?php if($errors->has('cpf')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('cpf')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-lg-5 ie" style="display: none;">
                                <div class="checkout__input">
                                    <p>IE<span>*</span></p>
                                    <input id="doc" value="<?php echo e(old('ie')); ?>" name="ie" type="text">
                                    <?php if($errors->has('ie')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('ie')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-9">
                                <div class="checkout__input">
                                    <p>Rua<span>*</span></p>
                                    <input value="<?php echo e($enderecoCep != null ? $enderecoCep->logradouro : old('rua')); ?>" name="rua" type="text">
                                    <?php if($errors->has('rua')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('rua')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="checkout__input">
                                    <p>Nº<span>*</span></p>
                                    <input value="<?php echo e(old('numero')); ?>" name="numero" type="text">
                                    <?php if($errors->has('numero')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('numero')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="checkout__input">
                                    <p>Bairro<span>*</span></p>
                                    <input value="<?php echo e($enderecoCep != null ? $enderecoCep->bairro : old('bairro')); ?>" name="bairro" type="text">
                                    <?php if($errors->has('bairro')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('bairro')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="checkout__input">
                                    <p>Cidade<span>*</span></p>
                                    <input value="<?php echo e($enderecoCep != null ? $enderecoCep->localidade : old('cidade')); ?>" name="cidade" type="text">
                                    <?php if($errors->has('cidade')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('cidade')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-2">
                                <div class="checkout__input">
                                    <p>UF<span>*</span></p>
                                    <input data-mask="AA" data-mask-reverse="true" value="<?php echo e($enderecoCep != null ? $enderecoCep->uf : old('uf')); ?>" name="uf" type="text">
                                    <?php if($errors->has('uf')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('uf')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="checkout__input">
                                    <p>CEP<span>*</span></p>
                                    <input data-mask="00000-000" data-mask-reverse="true" value="<?php echo e($default['carrinho']->observacao != '' ? $default['carrinho']->observacao : old('cep')); ?>" name="cep" type="text">
                                    <?php if($errors->has('cep')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('cep')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="checkout__input">
                                    <p>Complemento<span></span></p>
                                    <input value="<?php echo e(old('complemento')); ?>" name="complemento" type="text">
                                    <?php if($errors->has('complemento')): ?>
                                    <label class="text-danger"><?php echo e($errors->first('complemento')); ?></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div class="checkout__input">
                            <p>Observação<span></span></p>
                            <input value="<?php echo e(old('observacao')); ?>" name="observacao" type="text"
                            placeholder="Observação sobre entrega por exemplo">
                        </div>


                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="checkout__order">
                            <h4>Seu Pedido</h4>
                            <div class="checkout__order__products">Produtos <span>Total</span></div>
                            <?php if($default['carrinho'] != null): ?>
                            <?php $__currentLoopData = $default['carrinho']->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <ul>
                                <li><?php echo e($i->produto->produto->nome); ?> 
                                    <span>R$ <?php echo e(number_format($i->produto->valor, 2, ',', '.')); ?></span>
                                </li>
                            </ul>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <div class="checkout__order__subtotal">Frete <span>R$ <?php echo e(number_format($default['carrinho']->valor_frete, 2, ',', '.')); ?></span></div>
                            <div class="checkout__order__total">Total <span>R$ <?php echo e($default['carrinho'] != null ? number_format($default['carrinho']->somaItens() + $default['carrinho']->valor_frete, 2, ',', '.') : '0,00'); ?></span></div>
                            

                            <button type="submit" class="site-btn">SALVAR</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
    $(function(){
        changeDoc()
    })
    $('#tp_doc').change((target) => {
        changeDoc()
    })

    function changeDoc(){
        let v = $('#tp_doc').val()

        if(v == 'cpf'){
            $('#doc').mask('000.000.000-00', {reverse: true});
            $('.lbl_doc').html('CPF<span>*</span>');
            $('.ie').css('display', 'none');

        }else{
            $('#doc').mask('00.000.000/0000-00', {reverse: true});
            $('.lbl_doc').html('CNPJ<span>*</span>');
            $('.ie').css('display', 'block');
        }
    }
</script>
<?php $__env->stopSection(); ?> 

<?php $__env->stopSection(); ?> 


<?php echo $__env->make('ecommerce.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/ecommerce/checkout.blade.php ENDPATH**/ ?>