<?php $__env->startSection('content'); ?>
<style type="text/css">
	.camera{
		height: 200px;
		width: 200px;
	}
</style>
<div class=" d-flex flex-column flex-column-fluid" id="kt_content">
	<div class="card card-custom gutter-b example example-compact">
		<div class="container <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
			<div class="col-lg-12">
				<br>
				<form method="post" id="form-cliente" action="/clientes/<?php echo e(isset($cliente) ? 'update' : 'save'); ?>" enctype="multipart/form-data">
					<input type="hidden" name="id" value="<?php echo e(isset($cliente) ? $cliente->id : 0); ?>">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">
							<h3 class="card-title"><?php echo e(isset($cliente) ? 'Editar' : 'Novo'); ?> Cliente</h3>
						</div>
					</div>
					<?php echo csrf_field(); ?>

					<?php if(isset($cliente)): ?>
					<?php if($cliente->valorCredito() > 0): ?>
					<h4>Valor de crédito: <strong class="text-info">R$ <?php echo e(number_format($cliente->valorCredito(), 2, ',', '.')); ?></strong></h4>
					<?php endif; ?>
					<?php endif; ?>
					<div class="row">
						<div class="col-xl-12">
							<div class="kt-section kt-section--first">
								<div class="kt-section__body">

									<div class="row">
										<div class="form-group col-sm-12 col-lg-12">
											<label>Pessoa:</label>
											<div class="radio-inline">

												<label class="radio radio-success">
													<input value="p_fisica" name="group1" type="radio" id="pessoaFisica" <?php if(isset($cliente)): ?> <?php if(strlen($cliente->cpf_cnpj)
													< 15): ?> checked <?php endif; ?> <?php endif; ?> <?php if(old('group1') == 'p_fisica'): ?> checked <?php endif; ?>/>
													<span></span>
													FISICA
												</label>
												<label class="radio radio-success">
													<input value="p_juridica" name="group1" type="radio" id="pessoaJuridica" <?php if(isset($cliente)): ?> <?php if(strlen($cliente->cpf_cnpj) > 15): ?> checked <?php endif; ?> <?php endif; ?> <?php if(old('group1') == 'p_juridica'): ?> checked <?php endif; ?>/>
													<span></span>
													JURIDICA
												</label>

												<label class="radio radio-success">
													<input value="p_ext" name="group1" type="radio" id="pessoaExt" <?php if(isset($cliente)): ?> <?php if($cliente->cpf_cnpj == '00.000.000/0000-00'): ?> checked <?php endif; ?> <?php endif; ?> <?php if(old('group1') == 'p_ext'): ?> checked <?php endif; ?>/>
													<span></span>
													EXTERIOR
												</label>
											</div>

										</div>
									</div>

									<div class="row">
										<div class="form-group validated col-sm-3 col-lg-4">
											<label class="col-form-label" id="lbl_cpf_cnpj">CPF</label>
											<div class="">
												<input type="text" id="cpf_cnpj" class="form-control <?php if($errors->has('cpf_cnpj')): ?> is-invalid <?php endif; ?>" name="cpf_cnpj" value="<?php echo e(isset($cliente) ? $cliente->cpf_cnpj : old('cpf_cnpj')); ?>">
												<?php if($errors->has('cpf_cnpj')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('cpf_cnpj')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<div class="form-group validated col-lg-2 col-md-2 col-sm-6">
											<label class="col-form-label">UF</label>

											<select class="custom-select form-control" id="sigla_uf" name="sigla_uf">
												<?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option <?php if(isset($cliente)): ?> <?php if($cliente->cidade->uf == $c): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($c); ?>" 
													<?php if(old('sigla_uf') == $c): ?>
													selected
													<?php endif; ?>>
													<?php echo e($c); ?>

												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>

										</div>
										<div class="form-group validated col-lg-2 col-md-2 col-sm-6">
											<br><br>
											<a type="button" id="btn-consulta-cadastro" onclick="consultaCadastro()" class="btn btn-success spinner-white spinner-right">
												<span>
													<i class="fa fa-search"></i>
												</span>
											</a>
										</div>

									</div>

									<div class="row">
										<div class="form-group validated col-sm-10 col-lg-6">
											<label class="col-form-label">Razao Social/Nome</label>
											<div class="">
												<input id="razao_social" type="text" class="form-control <?php if($errors->has('razao_social')): ?> is-invalid <?php endif; ?>" name="razao_social" value="<?php echo e(isset($cliente) ? $cliente->razao_social : old('razao_social')); ?>">
												<?php if($errors->has('razao_social')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('razao_social')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<div class="form-group validated col-sm-10 col-lg-6">
											<label class="col-form-label">Nome Fantasia</label>
											<div class="">
												<input id="nome_fantasia" type="text" class="form-control <?php if($errors->has('nome_fantasia')): ?> is-invalid <?php endif; ?>" name="nome_fantasia" value="<?php echo e(isset($cliente) ? $cliente->nome_fantasia : old('nome_fantasia')); ?>">
												<?php if($errors->has('nome_fantasia')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('nome_fantasia')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>


									<div class="row">

										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label" id="lbl_i_rg">IE/RG</label>
											<div class="">
												<input type="text" id="ie_rg" class="form-control <?php if($errors->has('ie_rg')): ?> is-invalid <?php endif; ?>" name="ie_rg" value="<?php echo e(isset($cliente) ? $cliente->ie_rg : old('ie_rg')); ?>">
												<?php if($errors->has('ie_rg')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('ie_rg')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<div class="form-group validated col-lg-2 col-md-3 col-sm-10">
											<label class="col-form-label">Consumidor Final</label>

											<select class="custom-select form-control" id="consumidor_final" name="consumidor_final">
												<option value=""></option>
												<option <?php if(isset($cliente) && $cliente->consumidor_final == 1): ?> selected <?php endif; ?> value="1" <?php if(old('consumidor_final') == 1): ?> selected <?php endif; ?> selected>SIM</option>
												<option <?php if(isset($cliente) && $cliente->consumidor_final == 0): ?> selected <?php endif; ?> value="0" <?php if(old('consumidor_final') == 0): ?> <?php endif; ?>>NAO</option>
											</select>
											<?php if($errors->has('consumidor_final')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('consumidor_final')); ?>

											</div>
											<?php endif; ?>

										</div>

										<div class="form-group validated col-lg-2 col-md-3 col-sm-10">
											<label class="col-form-label">Contribuinte</label>

											<select class="custom-select form-control" id="contribuinte" name="contribuinte">
												<option value=""></option>
												<option <?php if(isset($cliente) && $cliente->contribuinte == 1): ?> selected <?php endif; ?> value="1" <?php if(old('contribuinte') == 1): ?> selected <?php endif; ?> selected>SIM</option>
												<option <?php if(isset($cliente) && $cliente->contribuinte == 0): ?> selected <?php endif; ?> value="0" <?php if(old('contribuinte') == 0): ?> <?php endif; ?>>NAO</option>
											</select>
											<?php if($errors->has('contribuinte')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('contribuinte')); ?>

											</div>
											<?php endif; ?>

										</div>

										<div class="form-group validated col-sm-3 col-lg-2">
											<label class="col-form-label" id="lbl_i">Limite de Venda</label>
											<div class="">
												<input type="text" id="limite_venda" class="form-control <?php if($errors->has('limite_venda')): ?> is-invalid <?php endif; ?> money" name="limite_venda" value="<?php echo e(isset($cliente) ? $cliente->limite_venda : old('limite_venda')); ?>">
												<?php if($errors->has('limite_venda')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('limite_venda')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-3 col-lg-2">
											<label class="col-form-label" id="">Data de Aniversário</label>
											<div class="">
												<input type="text" id="data_aniversario" class="form-control <?php if($errors->has('data_aniversario')): ?> is-invalid <?php endif; ?>" data-mask="00/00" data-mask-reverse="true" name="data_aniversario" value="<?php echo e(isset($cliente) ? $cliente->data_aniversario : old('data_aniversario')); ?>">
												<?php if($errors->has('data_aniversario')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('data_aniversario')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

									</div>
									<hr>
									<h5>Endereço de Faturamento</h5>
									<div class="row">
										<div class="form-group validated col-sm-8 col-lg-8">
											<label class="col-form-label">Rua</label>
											<div class="">
												<input id="rua" type="text" class="form-control <?php if($errors->has('rua')): ?> is-invalid <?php endif; ?>" name="rua" value="<?php echo e(isset($cliente) ? $cliente->rua : old('rua')); ?>">
												<?php if($errors->has('rua')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('rua')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-2 col-lg-2">
											<label class="col-form-label">Número</label>
											<div class="">
												<input id="numero" type="text" class="form-control <?php if($errors->has('numero')): ?> is-invalid <?php endif; ?>" name="numero" value="<?php echo e(isset($cliente) ? $cliente->numero : old('numero')); ?>">
												<?php if($errors->has('numero')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('numero')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="form-group validated col-sm-8 col-lg-5">
											<label class="col-form-label">Complemento</label>
											<div class="">
												<input id="complemento" type="text" class="form-control <?php if($errors->has('complemento')): ?> is-invalid <?php endif; ?>" name="complemento" value="<?php echo e(isset($cliente) ? $cliente->complemento : old('complemento')); ?>">
												<?php if($errors->has('complemento')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('complemento')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-3">
											<label class="col-form-label">Bairro</label>
											<div class="">
												<input id="bairro" type="text" class="form-control <?php if($errors->has('bairro')): ?> is-invalid <?php endif; ?>" name="bairro" value="<?php echo e(isset($cliente) ? $cliente->bairro : old('bairro')); ?>">
												<?php if($errors->has('bairro')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('bairro')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-2">
											<label class="col-form-label">CEP</label>
											<div class="">
												<input id="cep" type="text" class="form-control <?php if($errors->has('cep')): ?> is-invalid <?php endif; ?>" name="cep" value="<?php echo e(isset($cliente) ? $cliente->cep : old('cep')); ?>">
												<?php if($errors->has('cep')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('cep')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-3">
											<label class="col-form-label">Email</label>
											<div class="">
												<input id="email" type="text" class="form-control <?php if($errors->has('email')): ?> is-invalid <?php endif; ?>" name="email" value="<?php echo e(isset($cliente) ? $cliente->email : old('email')); ?>">
												<?php if($errors->has('email')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('email')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-lg-4 col-md-5 col-sm-10">
											<label class="col-form-label text-left">Cidade</label>
											<select class="form-control select2" id="kt_select2_1" name="cidade_id">
												<?php $__currentLoopData = $cidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($c->id); ?>" <?php if(isset($cliente)): ?> <?php if($c->id == $cliente->cidade_id): ?> selected <?php endif; ?> <?php endif; ?> 
													<?php if(old('cidade') == $c->id): ?>
													selected
													<?php endif; ?>
													>
													<?php echo e($c->nome); ?> (<?php echo e($c->uf); ?>)
												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
											<?php if($errors->has('cidade')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('cidade')); ?>

											</div>
											<?php endif; ?>
										</div>

										<div class="form-group validated col-lg-3 col-md-3 col-sm-6">
											<label class="col-form-label text-left">Pais</label>
											<select class="form-control select2" id="kt_select2_3" name="cod_pais">
												<?php $__currentLoopData = $pais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($p->codigo); ?>" <?php if(isset($cliente)): ?> <?php if($p->codigo == $cliente->cod_pais): ?> selected <?php endif; ?> <?php else: ?> <?php if($p->codigo == 1058): ?> selected <?php endif; ?> <?php endif; ?> ><?php echo e($p->codigo); ?> -  (<?php echo e($p->nome); ?>)</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
											<?php if($errors->has('cod_pais')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('cod_pais')); ?>

											</div>
											<?php endif; ?>
										</div>

										<div class="form-group validated col-sm-8 col-lg-4">
											<label class="col-form-label">ID estrangeiro (Opcional)</label>
											<div class="">
												<input id="id_estrangeiro" type="text" class="form-control <?php if($errors->has('id_estrangeiro')): ?> is-invalid <?php endif; ?>" name="id_estrangeiro" value="<?php echo e(isset($cliente) ? $cliente->id_estrangeiro : old('id_estrangeiro')); ?>">
												<?php if($errors->has('id_estrangeiro')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('id_estrangeiro')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-3">
											<label class="col-form-label">Telefone (Opcional)</label>
											<div class="">
												<input id="telefone" type="text" class="form-control <?php if($errors->has('telefone')): ?> is-invalid <?php endif; ?>" name="telefone" value="<?php echo e(isset($cliente) ? $cliente->telefone : old('telefone')); ?>">
												<?php if($errors->has('telefone')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('telefone')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-3">
											<label class="col-form-label">Celular (Opcional)</label>
											<div class="">
												<input id="celular" type="text" class="form-control <?php if($errors->has('celular')): ?> is-invalid <?php endif; ?>" name="celular" value="<?php echo e(isset($cliente) ? $cliente->celular : old('celular')); ?>">
												<?php if($errors->has('celular')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('celular')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-3">
											<label class="col-form-label">Grupo (Opcional)</label>
											<div class="">
												
												<select class="custom-select form-control" name="grupo_id">
													<option value="0">--</option>
													<?php $__currentLoopData = $grupos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option <?php if(isset($cliente)): ?> <?php if($cliente->grupo_id == $g->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($g->id); ?>" 
														<?php if(old('grupo_id') == $g->id): ?>
														selected
														<?php endif; ?>>
														<?php echo e($g->nome); ?>

													</option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-3">
											<label class="col-form-label">Assessor (Opcional)</label>
											<div class="">
												
												<select class="custom-select form-control" name="acessor_id">
													<option value="0">--</option>
													<?php $__currentLoopData = $acessores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option <?php if(isset($cliente)): ?> <?php if($cliente->acessor_id == $a->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($a->id); ?>" 
														<?php if(old('acessor_id') == $a->id): ?>
														selected
														<?php endif; ?>>
														<?php echo e($a->razao_social); ?>

													</option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>
											</div>
										</div>

										<div class="form-group validated col-lg-12 col-md-12 col-sm-12">
											<label class="col-xl-12 col-lg-12 col-form-label text-left">Imagem</label>
											<div class="col-lg-12 col-xl-12">

												<div class="image-input image-input-outline" id="kt_image_1">
													<div class="image-input-wrapper search-div"
													<?php if(!isset($cliente) || $cliente->imagem == ''): ?> style="background-image: url(/foto_usuario/user.png)" <?php else: ?>
													style="background-image: url(/imgs_clientes/<?php echo e($cliente->imagem); ?>)"
													<?php endif; ?>></div>
													<label class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow search-div" data-action="change" data-toggle="tooltip" title="" data-original-title="Change avatar">
														<i class="fa fa-pencil icon-sm text-muted"></i>
														<input type="file" id="file" name="file" accept=".png, .jpg, .jpeg">
														<input type="hidden" name="profile_avatar_remove">
													</label>
													<span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow search-div" data-action="cancel" data-toggle="tooltip" title="" data-original-title="Cancel avatar">
														<i class="fa fa-close icon-xs text-muted"></i>
													</span>

													<button type="button" id="btn-foto" class="btn btn-info btn-sm btn-block">
														<i class="la la-camera"></i>
													Tirar foto</button>

												</div>
												<span class="form-text text-muted">.png, .jpg, .jpeg</span>
												<?php if($errors->has('file')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('file')); ?>

												</div>
												<?php endif; ?>

											</div>
										</div>
									</div>

									<div class="row">
										<div class="form-group validated col-sm-3 col-lg-2">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Dados do Contador</label>
											<div class="col-12">
												<span class="switch switch-outline switch-info">
													<label>
														<input value="true" <?php if(isset($cliente) && $cliente->contador_nome != ""): ?> checked <?php endif; ?> <?php if(old('info_contador')): ?> checked <?php endif; ?> type="checkbox" name="info_contador" id="info_contador">
														<span></span>
													</label>
												</span>
											</div>
										</div>

										<div class="form-group validated col-sm-5 col-lg-3 ct">
											<label class="col-form-label">Nome</label>
											<div class="">
												<input id="contador_nome" type="text" class="form-control <?php if($errors->has('contador_nome')): ?> is-invalid <?php endif; ?>" name="contador_nome" value="<?php echo e(isset($cliente) ? $cliente->contador_nome : old('contador_nome')); ?>">
												<?php if($errors->has('contador_nome')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('contador_nome')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-2 ct">
											<label class="col-form-label">Telefone</label>
											<div class="">
												<input id="contador_telefone" type="text" class="form-control <?php if($errors->has('contador_telefone')): ?> is-invalid <?php endif; ?> telefone" name="contador_telefone" value="<?php echo e(isset($cliente) ? $cliente->contador_telefone : old('contador_telefone')); ?>">
												<?php if($errors->has('contador_telefone')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('contador_telefone')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-5 col-lg-4 ct">
											<label class="col-form-label">Email</label>
											<div class="">
												<input id="contador_email" type="email" class="form-control <?php if($errors->has('contador_email')): ?> is-invalid <?php endif; ?>" name="contador_email" value="<?php echo e(isset($cliente) ? $cliente->contador_email : old('contador_email')); ?>">
												<?php if($errors->has('contador_email')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('contador_email')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="form-group validated col-sm-8 col-lg-6 col-12">
											<label class="col-form-label">Observação</label>
											<div class="">
												<input id="observacao" type="text" class="form-control <?php if($errors->has('observacao')): ?> is-invalid <?php endif; ?>" name="observacao" value="<?php echo e(isset($cliente) ? $cliente->observacao : old('observacao')); ?>">
												<?php if($errors->has('observacao')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('observacao')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-3 col-12">
											<label class="col-form-label">Vendedor/Funcionário</label>
											<div class="">
												<select class="custom-select form-control" name="funcionario_id">
													<option value="0">--</option>
													<?php $__currentLoopData = $funcionarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option <?php if(isset($cliente)): ?> <?php if($cliente->funcionario_id == $f->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($f->id); ?>" 
														<?php if(old('funcionario_id') == $f->id): ?>
														selected
														<?php endif; ?>>
														<?php echo e($f->nome); ?>

													</option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>
												<?php if($errors->has('funcionario_id')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('funcionario_id')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<div class="form-group validated col-sm-3 col-lg-2">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Receita ótica</label>
											<div class="col-12">
												<span class="switch switch-outline switch-info">
													<label>
														<input value="true" <?php if(isset($cliente) && $cliente->receitaOtica): ?> checked <?php endif; ?> type="checkbox" name="receita_otica" id="receita_otica">
														<span></span>
													</label>

													<?php if(isset($cliente) && $cliente->receitaOtica): ?>
													<button type="button" onclick="$('#modal-otica').modal('show')" class="btn btn-sm btn-info">Ver receita</button>
													<?php endif; ?>
												</span>
											</div>
										</div>
									</div>

									<hr>
									<h5>Endereço de Cobrança (Opcional)</h5>
									<div class="row">
										<div class="form-group validated col-sm-8 col-lg-6">
											<label class="col-form-label">Rua</label>
											<div class="">
												<input id="rua_cobranca" type="text" class="form-control <?php if($errors->has('rua_cobranca')): ?> is-invalid <?php endif; ?>" name="rua_cobranca" value="<?php echo e(isset($cliente) ? $cliente->rua_cobranca : old('rua_cobranca')); ?>">
												<?php if($errors->has('rua_cobranca')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('rua_cobranca')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-2 col-lg-2">
											<label class="col-form-label">Número</label>
											<div class="">
												<input id="numero_cobranca" type="text" class="form-control <?php if($errors->has('numero_cobranca')): ?> is-invalid <?php endif; ?>" name="numero_cobranca" value="<?php echo e(isset($cliente) ? $cliente->numero_cobranca : old('numero_cobranca')); ?>">
												<?php if($errors->has('numero_cobranca')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('numero_cobranca')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-4">
											<label class="col-form-label">Bairro</label>
											<div class="">
												<input id="bairro_cobranca" type="text" class="form-control <?php if($errors->has('bairro_cobranca')): ?> is-invalid <?php endif; ?>" name="bairro_cobranca" value="<?php echo e(isset($cliente) ? $cliente->bairro_cobranca : old('bairro_cobranca')); ?>">
												<?php if($errors->has('bairro_cobranca')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('bairro_cobranca')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-8 col-lg-2">
											<label class="col-form-label">CEP</label>
											<div class="">
												<input id="cep_cobranca" type="text" class="form-control <?php if($errors->has('cep_cobranca')): ?> is-invalid <?php endif; ?>" name="cep_cobranca" value="<?php echo e(isset($cliente) ? $cliente->cep_cobranca : old('cep_cobranca')); ?>">
												<?php if($errors->has('cep_cobranca')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('cep_cobranca')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-lg-4 col-md-6 col-sm-10">
											<label class="col-form-label text-left col-lg-4 col-sm-12">Cidade</label>

											<select class="form-control select2" id="kt_select2_2" name="cidade_cobranca">
												<option value="-">--</option>
												<?php $__currentLoopData = $cidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($c->id); ?>" <?php if(isset($cliente)): ?> <?php if($c->id == $cliente->cidade_cobranca_id): ?>selected
													<?php endif; ?>
													<?php endif; ?> >
													<?php echo e($c->nome); ?> (<?php echo e($c->uf); ?>)
												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
											<?php if($errors->has('cidade_cobranca_id')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('cidade_cobranca_id')); ?>

											</div>
											<?php endif; ?>
										</div>
									</div>
								</div>

							</div>
						</div>
					</div>
				</div>

				<?php if(isset($cliente)): ?>
				<input type="hidden" id="receita" name="receita" value="<?php echo e($cliente->receitaOtica ? json_encode($cliente->receitaOtica) : '[]'); ?>">
				<?php else: ?>
				<input type="hidden" id="receita" name="receita" value="[]">
				<?php endif; ?>
				<div class="card-footer">

					<div class="row">
						<div class="col-xl-2">

						</div>
						<div class="col-lg-3 col-sm-6 col-md-4">
							<a style="width: 100%" class="btn btn-danger" href="/clientes">
								<i class="la la-close"></i>
								<span class="">Cancelar</span>
							</a>
						</div>
						<div class="col-lg-3 col-sm-6 col-md-4">
							<button style="width: 100%" type="submit" class="btn btn-success">
								<i class="la la-check"></i>
								<span class="">Salvar</span>
							</button>
						</div>

					</div>
				</div>
			</form>
		</div>
	</div>
</div>
</div>

<div class="modal fade" id="modal-foto" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Tirar Foto</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-12">

						<video style="width: 100%; height: 400px;" id="video"></video>
						<canvas style="display: none" id='canvas'></canvas>

					</div>
					<div class="col-12">
						<button class="btn btn-info" type="button" id='capture'>
							<i class="la la-camera"></i>
							Capturar
						</button>
					</div>
				</div>

			</div>
			<div class="modal-footer">
				<button type="button" id="btn-frete" class="btn btn-danger font-weight-bold spinner-white spinner-right" data-dismiss="modal" aria-label="Close">Fechar</button>

			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-otica" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-xl" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Cadastro de receita ótica</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-lg-6 bg-light-success">
						<div class="row">

							<h5 class="col-12 mt-2">Longe olho direito</h5>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Esf.</label>
								<input type="text" value="" id="esf_od_longe" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Cil.</label>
								<input type="text" value="" id="cil_od_longe" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Eixo</label>
								<input type="text" value="" id="eixo_od_longe" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">DNP</label>
								<input type="text" value="" id="dnp_od_longe" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">DP</label>
								<input type="text" value="" id="dp_od_longe" class="form-control">
							</div>
						</div>
					</div>

					<div class="col-lg-6 bg-light-primary">
						<div class="row">

							<h5 class="col-12 mt-2">Longe olho esquerdo</h5>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Esf.</label>
								<input type="text" value="" id="esf_oe_longe" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Cil.</label>
								<input type="text" value="" id="cli_oe_longe" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Eixo</label>
								<input type="text" value="" id="eixo_oe_longe" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">DNP</label>
								<input type="text" value="" id="dnp_oe_longe" class="form-control">
							</div>
							
						</div>
					</div>
				</div>

				<div class="row mt-2">
					<div class="col-lg-6 bg-light-success">
						<div class="row">

							<h5 class="col-12 mt-2">Perto olho direito</h5>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Esf.</label>
								<input type="text" value="" id="esf_od_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Cil.</label>
								<input type="text" value="" id="cil_od_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Eixo</label>
								<input type="text" value="" id="eixo_od_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Adição</label>
								<input type="text" value="" id="adicao_od_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Altura</label>
								<input type="text" value="" id="altura_od_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">DNP</label>
								<input type="text" value="" id="dnp_od_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">DP</label>
								<input type="text" value="" id="dp_od_perto" class="form-control">
							</div>
						</div>
					</div>

					<div class="col-lg-6 bg-light-primary">
						<div class="row">

							<h5 class="col-12 mt-2">Perto olho esquerdo</h5>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Esf.</label>
								<input type="text" value="" id="esf_oe_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Cil.</label>
								<input type="text" value="" id="cil_oe_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Eixo</label>
								<input type="text" value="" id="eixo_oe_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Adição</label>
								<input type="text" value="" id="adicao_oe_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">Altura</label>
								<input type="text" value="" id="altura_oe_perto" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-6">
								<label class="col-form-label" id="">DNP</label>
								<input type="text" value="" id="dnp_oe_perto" class="form-control">
							</div>
							
							
						</div>
					</div>
				</div>

				<div class="row mt-2">
					<div class="col-lg-12">
						<div class="row">

							<div class="form-group validated col-sm-4 col-lg-4 col-6">
								<label class="col-form-label" id="">Armação</label>
								<input type="text" value="" id="armacao" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-2">
								<label class="col-form-label" id="">Qtd. armação</label>
								<input type="text" value="" id="qtd_armacao" class="form-control qtd-p">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-2">
								<label class="col-form-label" id="">Valor armação</label>
								<input type="text" value="" id="valor_armacao" class="form-control money">
							</div>

							<div class="form-group validated col-sm-4 col-lg-4 col-6">
								<label class="col-form-label" id="">Lente</label>
								<input type="text" value="" id="lente" class="form-control">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-2">
								<label class="col-form-label" id="">Qtd. lente</label>
								<input type="text" value="" id="qtd_lente" class="form-control qtd-p">
							</div>
							<div class="form-group validated col-sm-4 col-lg-2 col-2">
								<label class="col-form-label" id="">Valor lente</label>
								<input type="text" value="" id="valor_lente" class="form-control money">
							</div>

							<div class="form-group validated col-sm-4 col-lg-4 col-6">
								<label class="col-form-label" id="">Tratamento</label>
								<input type="text" value="" id="tratamento" class="form-control">
							</div>

							<div class="form-group validated col-sm-4 col-lg-4 col-6">
								<label class="col-form-label" id="">Médico</label>
								<input type="text" value="" id="medico" class="form-control">
							</div>

							<div class="form-group validated col-sm-4 col-lg-3 col-6">
								<label class="col-form-label" id="">Tipo de lente</label>
								<input type="text" value="" id="tipo_lente" class="form-control">
							</div>

							<div class="form-group validated col-sm-4 col-lg-3 col-6">
								<label class="col-form-label" id="">Previsão de retorno (dias)</label>
								<input data-mask="0000" type="text" value="" id="previsao_retorno_dias" class="form-control">
							</div>

							<div class="form-group validated col-sm-4 col-lg-3 col-6">
								<label class="col-form-label" id="">Previsão de retorno (dias)</label>
								<input type="text" value="" id="data" class="form-control date-input">
							</div>

							<div class="form-group validated col-12">
								<label class="col-form-label" id="">Referência</label>
								<input type="text" value="" id="referencia" class="form-control">
							</div>

							<div class="form-group validated col-12">
								<label class="col-form-label" id="">Observação</label>
								<input type="text" value="" id="observacao" class="form-control">
							</div>
						</div>
					</div>
				</div>


			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
				<button type="submit" id="salvarReceita" class="btn btn-light-info font-weight-bold">Salvar</button>
			</div>
		</div>
	</div>
</div>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
	$(function () {
		isChecked()
		// $('#modal-otica').modal('show')
		verificaReceita()
	});

	function verificaReceita(){
		let receita = $('#receita').val()
		if(receita != '[]'){
			receita = JSON.parse(receita)

			$('#esf_od_longe').val(receita.esf_od_longe)
			$('#cil_od_longe').val(receita.cil_od_longe)
			$('#eixo_od_longe').val(receita.eixo_od_longe)
			$('#dnp_od_longe').val(receita.dnp_od_longe)
			$('#dp_od_longe').val(receita.dp_od_longe)
			$('#esf_oe_longe').val(receita.esf_oe_longe)
			$('#cli_oe_longe').val(receita.cli_oe_longe)
			$('#eixo_oe_longe').val(receita.eixo_oe_longe)
			$('#dnp_oe_longe').val(receita.dnp_oe_longe)
			$('#esf_od_perto').val(receita.esf_od_perto)
			$('#cil_od_perto').val(receita.cil_od_perto)
			$('#eixo_od_perto').val(receita.eixo_od_perto)
			$('#adicao_od_perto').val(receita.adicao_od_perto)
			$('#altura_od_perto').val(receita.altura_od_perto)
			$('#dnp_od_perto').val(receita.dnp_od_perto)
			$('#dp_od_perto').val(receita.dp_od_perto)
			$('#esf_oe_perto').val(receita.esf_oe_perto)
			$('#cil_oe_perto').val(receita.cil_oe_perto)
			$('#eixo_oe_perto').val(receita.eixo_oe_perto)
			$('#adicao_oe_perto').val(receita.adicao_oe_perto)
			$('#altura_oe_perto').val(receita.altura_oe_perto)
			$('#dnp_oe_perto').val(receita.dnp_oe_perto)
			$('#armacao').val(receita.armacao)
			$('#qtd_armacao').val(receita.qtd_armacao)
			$('#valor_armacao').val(receita.valor_armacao)
			$('#lente').val(receita.lente)
			$('#qtd_lente').val(receita.qtd_lente)
			$('#valor_lente').val(receita.valor_lente)
			$('#tratamento').val(receita.tratamento)
			$('#medico').val(receita.medico)
			$('#tipo_lente').val(receita.tipo_lente)
			$('#previsao_retorno_dias').val(receita.previsao_retorno_dias)
			$('#data').val(receita.data)
			$('#referencia').val(receita.referencia)
			$('#observacao').val(receita.observacao)
		}
	}

	$('#info_contador').change(() => {
		isChecked()
	})

	function isChecked(){
		let checked = $('#info_contador').is(':checked')

		if(checked){
			$('.ct').css('display', 'block')
		}else{
			$('.ct').css('display', 'none')
		}
	}

	$('#btn-foto').click(() => {
		$('#modal-foto').modal('show')
		navigator.mediaDevices.getUserMedia({video: true})
		.then(function (mediaStream) {
			const video = document.querySelector('#video');
			video.srcObject = mediaStream;
			video.play();
		})
		.catch(function (err) {
			swal("Alerta", "Não há permissões para acessar a webcam", "warning")
		})
	})

	var blobFyle = null
	document.querySelector('#capture').addEventListener('click', function (e) {
		var canvas = document.querySelector("#canvas");  
		canvas.height = video.videoHeight;
		canvas.width = video.videoWidth;
		var context = canvas.getContext('2d');
		context.drawImage(video, 0, 0)

		let dataURI = canvas.toDataURL('image/png'); 
		// console.log(dataURI)
		$('#modal-foto').modal('hide')

		$('.image-input-wrapper').css('background-image', 'url("' + dataURI + '")')
		// var input_file = document.getElementById("file");
		// // input_file.src = dataURI;
		// $('#file').val(dataURI)
		blobFyle = dataURI

		setTimeout(() => {
			var canvas = document.querySelector("#canvas");
			canvas.toBlob(function (blob) {
				console.log(blob)
				// blobFyle = blob

			}, 'image/png')
		}, 300)
	})

	document.getElementById('form-cliente').addEventListener('submit', salvarCliente);
	function salvarCliente(event){
		event.preventDefault();
		let form = document.getElementById('form-cliente');
		let image = document.createElement('input');

		if(blobFyle != null){

			image.setAttribute('name', 'blob');
			image.setAttribute('type', 'hidden');
			image.setAttribute('value', blobFyle);
			// $('#blob').value=blobFyle

			form.appendChild(image);

		}
		setTimeout(() => {
			form.submit();
		}, 100)

	}

	$('#receita_otica').change(() => {
		$('#modal-otica').modal('show')
	})

	$('#salvarReceita').click(() => {
		let esf_od_longe = $('#esf_od_longe').val()
		let cil_od_longe = $('#cil_od_longe').val()
		let eixo_od_longe = $('#eixo_od_longe').val()
		let dnp_od_longe = $('#dnp_od_longe').val()
		let dp_od_longe = $('#dp_od_longe').val()

		let esf_oe_longe = $('#esf_oe_longe').val()
		let cli_oe_longe = $('#cli_oe_longe').val()
		let eixo_oe_longe = $('#eixo_oe_longe').val()
		let dnp_oe_longe = $('#dnp_oe_longe').val()

		let esf_od_perto = $('#esf_od_perto').val()
		let cil_od_perto = $('#cil_od_perto').val()
		let eixo_od_perto = $('#eixo_od_perto').val()
		let adicao_od_perto = $('#adicao_od_perto').val()
		let altura_od_perto = $('#altura_od_perto').val()
		let dnp_od_perto = $('#dnp_od_perto').val()
		let dp_od_perto = $('#dp_od_perto').val()

		let esf_oe_perto = $('#esf_oe_perto').val()
		let cil_oe_perto = $('#cil_oe_perto').val()
		let eixo_oe_perto = $('#eixo_oe_perto').val()
		let adicao_oe_perto = $('#adicao_oe_perto').val()
		let altura_oe_perto = $('#altura_oe_perto').val()
		let dnp_oe_perto = $('#dnp_oe_perto').val()

		let armacao = $('#armacao').val()
		let qtd_armacao = $('#qtd_armacao').val()
		let valor_armacao = $('#valor_armacao').val()
		let lente = $('#lente').val()
		let qtd_lente = $('#qtd_lente').val()
		let valor_lente = $('#valor_lente').val()

		let tratamento = $('#tratamento').val()
		let medico = $('#medico').val()
		let tipo_lente = $('#tipo_lente').val()
		let previsao_retorno_dias = $('#previsao_retorno_dias').val()
		let data = $('#data').val()

		let referencia = $('#referencia').val()
		let observacao = $('#observacao').val()

		let js = {
			esf_od_longe: esf_od_longe,
			cil_od_longe: cil_od_longe,
			eixo_od_longe: eixo_od_longe,
			dnp_od_longe: dnp_od_longe,
			dp_od_longe: dp_od_longe,
			esf_oe_longe: esf_oe_longe,
			cli_oe_longe: cli_oe_longe,
			eixo_oe_longe: eixo_oe_longe,
			dnp_oe_longe: dnp_oe_longe,
			esf_od_perto: esf_od_perto,
			cil_od_perto: cil_od_perto,
			eixo_od_perto: eixo_od_perto,
			adicao_od_perto: adicao_od_perto,
			altura_od_perto: altura_od_perto,
			dnp_od_perto: dnp_od_perto,
			dp_od_perto: dp_od_perto,
			esf_oe_perto: esf_oe_perto,
			cil_oe_perto: cil_oe_perto,
			eixo_oe_perto: eixo_oe_perto,
			adicao_oe_perto: adicao_oe_perto,
			altura_oe_perto: altura_oe_perto,
			dnp_oe_perto: dnp_oe_perto,
			armacao: armacao,
			qtd_armacao: qtd_armacao,
			valor_armacao: valor_armacao,
			lente: lente,
			qtd_lente: qtd_lente,
			valor_lente: valor_lente,
			tratamento: tratamento,
			medico: medico,
			tipo_lente: tipo_lente,
			previsao_retorno_dias: previsao_retorno_dias,
			data: data,
			referencia: referencia,
			observacao: observacao,
		}

		$('#receita').val(JSON.stringify(js))
		$('#modal-otica').modal('hide')
	})

</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/clientes/register.blade.php ENDPATH**/ ?>