<?php $__env->startSection('content'); ?>

<div class=" d-flex flex-column flex-column-fluid" id="kt_content">
	<div class="card card-custom gutter-b example example-compact">
		<div class="container <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
			<div class="col-lg-12">
				<br>

				<form method="post" action="<?php echo e(isset($codigo) ? '/codigoDesconto/update': '/codigoDesconto/save'); ?>">
					<input type="hidden" name="id" value="<?php echo e(isset($codigo) ? $codigo->id : 0); ?>">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">
							<h3 class="card-title"><?php echo e(isset($codigo) ? "Editar": "Cadastrar"); ?> Cupom</h3>
						</div>
					</div>
					<?php echo csrf_field(); ?>

					<div class="row">
						<div class="col-xl-12">
							<div class="kt-section kt-section--first">
								<div class="kt-section__body">
									<div class="row">

										<div class="form-group validated col-sm-4 col-lg-4">
											<label class="col-form-label">Descrição</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('descricao')): ?> is-invalid <?php endif; ?>" name="descricao" value="<?php echo e(isset($codigo) ? $codigo->descricao : old('descricao')); ?>" >
												<?php if($errors->has('descricao')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('descricao')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<div class="form-group validated col-sm-6 col-lg-2">
											<label class="col-form-label">Código</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('codigo')): ?> is-invalid <?php endif; ?>" id="codigoPromocional" name="codigo" value="<?php echo e(isset($codigo) ? $codigo->codigo : old('codigo')); ?>">
												<?php if($errors->has('codigo')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('codigo')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<div class="form-group validated col-lg-1 col-md-2 col-sm-6">
											<br><br>
											<a type="button" id="gerar-codigo" class="btn btn-success spinner-white spinner-right">
												<span>
													<i class="fa fa-key"></i>
												</span>
											</a>
										</div>

										<div class="form-group validated col-sm-3 col-lg-2 col-6">
											<label class="col-form-label">Tipo</label>
											<div class="">
												<select class="custom-select form-control" id="tipo" name="tipo">
													<option value="valor">Valor R$</option>
													<option value="percentual">Percentual %</option>
												</select>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-2">
											<label class="col-form-label">Valor</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('valor')): ?> is-invalid <?php endif; ?> money" name="valor" value="<?php echo e(isset($codigo) ? number_format($codigo->valor, 2) : old('valor')); ?>" >
												<?php if($errors->has('valor')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('valor')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-2">
											<label class="col-form-label">Valor minímo do pedido</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('valor_minimo_pedido')): ?> is-invalid <?php endif; ?> money" name="valor_minimo_pedido" value="<?php echo e(isset($codigo) ? number_format($codigo->valor_minimo_pedido, 2) : old('valor_minimo_pedido')); ?>" >
												<?php if($errors->has('valor_minimo_pedido')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('valor_minimo_pedido')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-2">
											<label class="col-form-label">Data de expiração</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('expiracao')): ?> is-invalid <?php endif; ?>" name="expiracao" value="<?php echo e(isset($codigo) ? \Carbon\carbon::parse($codigo->expiracao)->format('d/m/Y') : old('expiracao')); ?>" data-mask="00/00/0000" data-mask-reverse="true">
												<?php if($errors->has('expiracao')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('expiracao')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<?php if(isset($codigo)): ?>
										<?php if($codigo->cliente): ?>
										<div>
											<br><br>
											<p class="text-danger ml-2">Notificaçao para cliente 
												<strong><?php echo e($codigo->cliente->nome); ?></strong>
											</p>
										</div>
										<?php else: ?>
										<div>
											<br><br>
											<p class="text-danger ml-2">Notificaçao para todos os clientes</p>
										</div>
										<?php endif; ?>
										<?php endif; ?>

										<?php if(!isset($codigo)): ?>
										<div class="form-group validated col-12 col-lg-2 col-md-6 mt-4">
											Todos os Clientes
											<div class="switch switch-outline switch-success mt-2">
												<label class="">
													<input id="todos" name="todos" class="red-text" type="checkbox">
													<span class="lever"></span>

												</label>
											</div>
										</div>

										<div class="form-group validated col-12 col-lg-4 col-md-6">
											<label class="col-form-label">Cliente</label><br>
											<select class="form-control select2 <?php if($errors->has('cliente')): ?> is-invalid <?php endif; ?>" id="kt_select2_1" name="cliente_id">
												<option value="null">Selecione o cliente</option>
												<?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option 
												value="<?php echo e($c->id); ?>"><?php echo e($c->id); ?> - <?php echo e($c->nome); ?></option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
											<?php if($errors->has('cliente')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('cliente')); ?>

											</div>
											<?php endif; ?>
										</div>

										<?php endif; ?>


									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="card-footer">

						<div class="row">
							<div class="col-xl-2">

							</div>
							<div class="col-lg-3 col-sm-6 col-md-4">
								<a style="width: 100%" class="btn btn-danger" href="/codigoDesconto">
									<i class="la la-close"></i>
									<span class="">Cancelar</span>
								</a>
							</div>
							<div class="col-lg-3 col-sm-6 col-md-4">
								<button style="width: 100%" type="submit" class="btn btn-success">
									<i class="la la-check"></i>
									<span class="">Salvar</span>
								</button>
							</div>

						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>	
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/codigoDesconto/register.blade.php ENDPATH**/ ?>