<?php $__env->startSection('content'); ?>

<section class="shoping-cart">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="shoping__cart__table">
                    <table>
                        <thead>
                            <tr>
                                <th class="shoping__product">Produto</th>
                                <th>Valor</th>
                                <th>Quantidade</th>
                                <th>SubTotal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($default['carrinho'] != null): ?>
                            <?php $__currentLoopData = $default['carrinho']->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="shoping__cart__item">
                                    <img height="40" src="/ecommerce/produtos/<?php echo e($i->produto->galeria[0]->img); ?>" alt="">
                                    <h5>
                                        <?php echo e($i->produto->produto->nome); ?>


                                        <?php if($i->produto->produto->grade): ?>
                                        | <?php echo e($i->produto->produto->str_grade); ?>

                                        <?php endif; ?>
                                    </h5>
                                </td>
                                <td class="shoping__cart__price">
                                    R$ <?php echo e(number_format($i->produto->valor, 2, ',', '.')); ?>

                                </td>
                                <td class="shoping__cart__quantity">
                                    <div class="quantity">
                                        <div class="pro-qty">
                                            <input id="<?php echo e($i->id); ?>" class="qtd" type="number" value="<?php echo e($i->quantidade); ?>">
                                        </div>
                                    </div>
                                </td>
                                <td class="shoping__cart__total">
                                    R$ <?php echo e(number_format($i->quantidade*$i->produto->valor, 2, ',', '.')); ?>

                                </td>
                                <td class="shoping__cart__item__close">
                                    <a href="<?php echo e($rota); ?>/<?php echo e($i->id); ?>/deleteItemCarrinho"><span class="icon_close"></span></a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="shoping__cart__btns">
                    <a href="<?php echo e($rota); ?>" class="primary-btn cart-btn">CONTINUAR COMPRANDO</a>
                    <a href="<?php echo e($rota); ?>/carrinho" class="primary-btn cart-btn cart-btn-right"><span class="icon_loading"></span>
                    ATUALIZAR CARRINHO</a>
                </div>
            </div>
            <input type="hidden" value="<?php echo e(csrf_token()); ?>" id="token">
            <div class="col-lg-6">
                <div class="shoping__continue">
                    <div class="shoping__discount">
                        <h5>Frete</h5>
                        <form action="#">
                            <?php if($default['carrinho'] != null): ?>
                            <input type="hidden" id="pedido_id" name="" value="<?php echo e($default['carrinho']->id); ?>">
                            <?php endif; ?>
                            <input id="cep" data-mask="00000-000" data-mask-reverse="true" type="text" placeholder="CEP">
                            <button id="btn-calcular-frete" type="button" class="site-btn">CALCULAR</button>
                            <div style="display: none" class="spinner-border text-secondary" role="status">
                                <span class="sr-only"></span>
                            </div>
                        </form>
                        <br>
                        <div class="frete">

                        </div>

                    </div>

                </div>
            </div>

            <input type="hidden" value="<?php echo e($default['carrinho'] != null ? $default['carrinho']->somaItens() : 0); ?>" id="soma_hidden" name="">
            <div class="col-lg-6">
                <div class="shoping__checkout">
                    <h5>CARRINHO TOTAL</h5>
                    <ul>
                        <li>Subtotal 
                            <span>
                                R$ <?php echo e($default['carrinho'] != null ? number_format($default['carrinho']->somaItens(), 2, ',', '.') : '0,00'); ?>

                            </span>
                        </li>
                        <li>Total 
                            <span id="total">
                                R$ <?php echo e($default['carrinho'] != null ? number_format($default['carrinho']->somaItens(), 2, ',', '.') : '0,00'); ?>

                            </span>
                        </li>
                    </ul>

                    <form method="get" action="<?php echo e($rota); ?>/checkout">
                        <input type="hidden" id="tp_frete" value="" name="tp_frete">
                        <button class="btn primary-btn">CONTINUAR PARA PAGAMENTO</button>
                    </form>
                    <!-- <a href="<?php echo e($rota); ?>/checkout" class="primary-btn">CONTINUAR PARA PAGAMENTO</a> -->
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?> 

<?php echo $__env->make('ecommerce.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/ecommerce/carrinho.blade.php ENDPATH**/ ?>