<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<div class="">
			<div class="col-sm-12 col-lg-4 col-md-6 col-xl-4">
				<?php if(isset($funcionamento)): ?>
				<a href="/funcionamentoDelivery" class="btn btn-lg btn-success">
					<i class="fa fa-plus"></i>Novo Dia
				</a>
				<?php endif; ?>

			</div>
		</div>
		<br>

		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<form method="post" action="/funcionamentoDelivery/save">
				<?php echo csrf_field(); ?>
				<input type="hidden" name="id" value="<?php echo e(isset($funcionamento->id) ? $funcionamento->id : 0); ?>">
				<div class="row align-items-center">
					<div class="form-group validated col-lg-3 col-md-3 col-sm-10">
						<label class="col-form-label">Dia da semana *</label>
						<?php if(!isset($funcionamento)): ?>
						<select class="custom-select form-control" id="dia" name="dia">
							<?php $__currentLoopData = $dias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option value="<?php echo e($d); ?>"><?php echo e($d); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
						<?php else: ?>
						<input type="text" class="form-control" name="dia" value="<?php echo e($funcionamento->dia); ?>" disabled="">
						<?php endif; ?>

					</div>
					<div class="form-group validated col-sm-2 col-lg-2">
						<label class="col-form-label">Horário início</label>
						<div class="">
							<input data-mask="00:00" data-mask-reverse="true" type="text" class="form-control" id="inicio" name="inicio" value="<?php echo e(isset($funcionamento->inicio_expediente) ? $funcionamento->inicio_expediente : '18:00'); ?>">
							<?php if($errors->has('inicio')): ?>
							<div class="invalid-feedback"><?php echo e($errors->first('inicio')); ?></div>
							<?php endif; ?>
						</div>
					</div>
					<div class="form-group validated col-sm-2 col-lg-2">
						<label class="col-form-label">Horário fim</label>
						<div class="">
							<input data-mask="00:00" data-mask-reverse="true" type="text" class="form-control" id="fim" name="fim" value="<?php echo e(isset($funcionamento->fim_expediente) ? $funcionamento->fim_expediente : '23:59'); ?>">
							<?php if($errors->has('fim')): ?>
							<div class="invalid-feedback"><?php echo e($errors->first('fim')); ?></div>
							<?php endif; ?>
						</div>
					</div>

					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button style="margin-top: 12px;" class="btn btn-light-success px-6 font-weight-bold">Salvar</button>
					</div>
				</div>

			</form>
		</div>

		<div class="row">
			<?php if(count($funcionamentos) == 7): ?>
			<h3 class="text-danger">Todos os dias da semana adicionados!</h3>
			<?php endif; ?>
		</div>

		<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

			<table class="datatable-table" style="max-width: 100%; overflow: scroll">
				<thead class="datatable-head">
					<tr class="datatable-row" style="left: 0px;">
						<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Dia</span></th>
						<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Inicio</span></th>
						<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Fim</span></th>
						<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Status</span></th>
						<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Ações</span></th>
					</tr>
				</thead>
				<tbody id="body" class="datatable-body">
					<?php $__currentLoopData = $funcionamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr class="datatable-row">
						<td class="datatable-cell">
							<span class="codigo" style="width: 150px;">
								<?php echo e($f->dia); ?>

							</span>
						</td>
						<td class="datatable-cell">
							<span class="codigo" style="width: 100px;">
								<?php echo e($f->inicio_expediente); ?>

							</span>
						</td>
						<td class="datatable-cell">
							<span class="codigo" style="width: 100px;">
								<?php echo e($f->fim_expediente); ?>

							</span>
						</td>
						<td class="datatable-cell">
							<span class="codigo" style="width: 100px;">
								<?php if($f->ativo): ?>
								<span class="label label-xl label-inline label-light-success">ATIVO</span>
								<?php else: ?>
								<span class="label label-xl label-inline label-light-danger">DESATIVADO</span>
								<?php endif; ?>
							</span>
						</td>

						<td class="datatable-cell">
							<span class="codigo" style="width: 150px;">

								<a href="/funcionamentoDelivery/edit/<?php echo e($f->id); ?>" class="btn btn-sm btn-warning">
									<i class="la la-edit"></i>					
								</a>

								<?php if($f->ativo): ?>
								<a title="desativar" href="/funcionamentoDelivery/alterarStatus/<?php echo e($f->id); ?>" class="btn btn-sm btn-danger">
									<i class="la la-times"></i>				
								</a>
								<?php else: ?>
								<a href="/funcionamentoDelivery/alterarStatus/<?php echo e($f->id); ?>" class="btn btn-sm btn-success">
									<i class="la la-check"></i>				
								</a>
								<?php endif; ?>
							</span>
						</td>
					</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>
		</div>

	</div>
</div>


<?php $__env->stopSection(); ?>	
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/funcionamentoDelivery/index.blade.php ENDPATH**/ ?>