<?php
namespace App\Services\Nfse;

use NFePHP\NFSeGinfes\Rps;
use NFePHP\Common\Certificate;
use NFePHP\NFSeGinfes\Common\Soap\SoapFake;
use NFePHP\NFSeGinfes\Tools;
use NFePHP\NFSeGinfes\Common\FakePretty;

error_reporting(E_ALL);
ini_set('display_errors', 'On');

class NFSeService{

	private $config; 
	private $certificado; 

	public function __construct($config, $certificado){
		$this->config = $config;
		$this->certificado = $certificado;
	}

	public function gerar(){

		$cert = Certificate::readPfx($this->certificado->arquivo, $this->certificado->senha);
		$configJson = json_encode($this->config);

		$soap = new SoapFake();
		$soap->disableCertValidation(true);

		$tools = new Tools($configJson, $cert);
		$tools->loadSoapClass($soap);

		$arps = [];
		$std = new \stdClass();
		$std->version = '1.00'; 
		$std->IdentificacaoRps = new \stdClass();
		$std->IdentificacaoRps->Numero = 11; 
		$std->IdentificacaoRps->Serie = '1';
		$std->IdentificacaoRps->Tipo = 1; 
		$std->DataEmissao = '2022-05-30T16:33:22';
		$std->NaturezaOperacao = 1; 

		$std->RegimeEspecialTributacao = 1;    

		$std->OptanteSimplesNacional = 1;
		$std->IncentivadorCultural = 2;
		$std->Status = 1; 

		$std->Tomador = new \stdClass();
		$std->Tomador->Cnpj = "99999999000191";
		$std->Tomador->Cpf = "12345678901";
		$std->Tomador->RazaoSocial = "Fulano de Tal";

		$std->Tomador->Endereco = new \stdClass();
		$std->Tomador->Endereco->Endereco = 'Rua das Rosas';
		$std->Tomador->Endereco->Numero = '111';
		$std->Tomador->Endereco->Complemento = 'Sobre Loja';
		$std->Tomador->Endereco->Bairro = 'Centro';
		$std->Tomador->Endereco->CodigoMunicipio = 3106200;
		$std->Tomador->Endereco->Uf = 'MG';
		$std->Tomador->Endereco->Cep = 30160010;

		$std->Servico = new \stdClass();
		$std->Servico->ItemListaServico = '11.01';
		$std->Servico->CodigoTributacaoMunicipio = '522310000';
		$std->Servico->Discriminacao = 'Teste de RPS';
		$std->Servico->CodigoMunicipio = 3106200;

		$std->Servico->Valores = new \stdClass();
		$std->Servico->Valores->ValorServicos = 100.00;
		$std->Servico->Valores->ValorDeducoes = 10.00;
		$std->Servico->Valores->ValorPis = 10.00;
		$std->Servico->Valores->ValorCofins = 10.00;
		$std->Servico->Valores->ValorInss = 10.00;
		$std->Servico->Valores->ValorIr = 10.00;
		$std->Servico->Valores->ValorCsll = 10.00;
		$std->Servico->Valores->IssRetido = 1;
		$std->Servico->Valores->ValorIss = 10.00;
		$std->Servico->Valores->OutrasRetencoes = 10.00;
		$std->Servico->Valores->Aliquota = 5;
		$std->Servico->Valores->ValorLiquidoNfse = 100.00;
		$std->Servico->Valores->DescontoIncondicionado = 10.00;
		$std->Servico->Valores->DescontoCondicionado = 10.00;

		// $std->IntermediarioServico = new \stdClass();
		// $std->IntermediarioServico->RazaoSocial = 'INSCRICAO DE TESTE SIATU - D AGUA -PAULINO S'; 
		// $std->IntermediarioServico->Cnpj = '99999999000191';
		// $std->IntermediarioServico->InscricaoMunicipal = '8041700010';

		// $std->ConstrucaoCivil = new \stdClass();
		// $std->ConstrucaoCivil->CodigoObra = '1234';
		// $std->ConstrucaoCivil->Art = '1234';

		$arps[] = new Rps($std);

		file_put_contents("xml.xml", $arps[0]->render());
		print_r($arps);
		die;

		$lote = time();

		$response = $tools->recepcionarLoteRps($arps, $lote);

		echo FakePretty::prettyPrint($response, '');

	}
}
