<?php

namespace App\Http\Controllers\Pdv;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Produto;

class ProdutoController extends Controller
{
    public function index(Request $request){
        $update_date = "";
        if($request->update_date){
            $update_date = $request->update_date;
        }

        $produtos = Produto::
        where('empresa_id', $request->empresa_id);

        if(strlen($update_date) > 0){
            $produtos->where('updated_at', '>', $update_date);
            // $produtos->where('updated_at', '>', '2022-12-06 00:00:00');
        }
        $produtos = $produtos->get();

        foreach($produtos as $p){
            $p->estoque_atual = $p->estoqueAtual2();
        }

        return response()->json($produtos, 200);
    }

    public function count(Request $request){
        $count = Produto::
        where('empresa_id', $request->empresa_id)
        ->count();

        return response()->json($count, 200);
    }

    public function limit(Request $request){

        $update_date = "";
        if($request->update_date){
            $update_date = $request->update_date;
        }

        $produtos = Produto::
        where('empresa_id', $request->empresa_id)
        ->limit(100)
        ->where('id', '>', $request->id);

        if(strlen($update_date) > 0){
            $produtos->where('updated_at', '>', $update_date);
        }
        $produtos = $produtos->get();

        foreach($produtos as $p){
            $p->estoque_atual = $p->estoqueAtual2();
        }

        return response()->json($produtos, 200);
    }
}
