<?php

namespace App\Http\Controllers\Ifood;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\IfoodConfig;
use App\Models\PedidoIfood;
use App\Models\ConfigNota;
use App\Models\PagamentoPedidoIfood;
use App\Models\ItemPedidoIfood;
use App\Models\AdicionalItemPedidoIfood;
use App\Restaurant\IfoodService;
use Dompdf\Dompdf;

class OrderController extends Controller
{
    protected $empresa_id = null;
    public function __construct(){

        $this->middleware(function ($request, $next) {
            $this->empresa_id = $request->empresa_id;
            $value = session('user_logged');
            if(!$value){
                return redirect("/login");
            }
            return $next($request);
        });
    }

    public function index(){

        $data = PedidoIfood::
        where('empresa_id', $this->empresa_id)
        ->orderBy('data_pedido', 'desc')
        ->paginate(15);

        return view('pedido_ifood/index', compact('data'))
        ->with('links', true)
        ->with('title', 'Pedidos iFood');
    }

    public function filter(Request $request){

        $search = $request->search;
        $status = $request->status;
        $data = PedidoIfood::
        where('empresa_id', $this->empresa_id)
        ->orderBy('data_pedido', 'desc');
        if($search){
            $data->where('nome_cliente', 'like', "%$search%");
        }
        if($status){
            $data->where('status', $status);
        }

        $data = $data->get();

        return view('pedido_ifood/index', compact('data', 'search', 'status'))
        ->with('title', 'Pedidos iFood');
    }

    public function getNewOrders(){
        $config = IfoodConfig::
        where('empresa_id', $this->empresa_id)
        ->first();

        $iFoodService = new IfoodService($config);

        $data = $iFoodService->getOrders("PLC");

        if(isset($data->message)){
            session()->flash("mensagem_erro", $data->message);
            return redirect('/ifood/config');
        }

        if($data == null){
            session()->flash("mensagem_erro", "Nenhum novo pedido encontrado!");
            return redirect()->back();
        }
        // echo "<pre>";
        // print_r($data == null);
        // echo "</pre>";
        // die;
        $contNewOrders = 0;
        try{
            foreach($data as $item){

                $pedido = PedidoIfood::where('pedido_id', $item->orderId)
                ->first();

                $detail = $iFoodService->getOrderDetail($item->orderId);

                if($pedido == null){
                    $dataOrder = [
                        'status' => $item->code,
                        'pedido_id' => $item->orderId,
                        'data_pedido' => $item->createdAt,
                        'empresa_id' => $this->empresa_id
                    ];
                    $pedido = PedidoIfood::create($dataOrder);
                    $contNewOrders++;
                }else{
                //alteração de status
                    $pedido->status = $item->code;
                    $pedido->save();
                }

                if($detail){
                    // echo "<pre>";
                    // print_r($detail);
                    // echo "</pre>";
                    // die;
                    $pedido->tipo_pedido = $detail->orderType;
                    if(isset($detail->delivery)){
                        $delivery = $detail->delivery->deliveryAddress;
                        $pedido->endereco = $delivery->formattedAddress;
                        $pedido->bairro = $delivery->neighborhood;
                        $pedido->cep = $delivery->postalCode;
                    }

                    if(isset($detail->customer)){
                        $customer = $detail->customer;

                        $pedido->nome_cliente = $customer->name;
                        $pedido->id_cliente = $customer->id;
                        $pedido->telefone_cliente = $customer->phone->number;
                        if(isset($customer->documentNumber)){
                            $pedido->cpf_na_nota = $customer->documentNumber;
                        }
                    }

                    $pedido->valor_produtos = $detail->total->subTotal;
                    $pedido->valor_entrega = $detail->total->deliveryFee;
                    $pedido->valor_total = $detail->total->orderAmount;
                    $pedido->taxas_adicionais = $detail->total->additionalFees;

                    $pedido->save();

                    $pedido->payments()->delete();
                    $pedido->itens()->delete();
                    if(isset($detail->payments->methods)){
                        $methods = $detail->payments->methods;
                        foreach($methods as $m){
                            $payData = [
                                'forma_pagamento' => $m->method,
                                'tipo_pagamento' => $m->type,
                                'bandeira_cartao' => isset($m->card) ? $m->card->brand : '',
                                'valor' => $m->value,
                                'pedido_id' => $pedido->id
                            ];

                            PagamentoPedidoIfood::create($payData);

                        }

                    }

                    foreach($detail->items as $it){
                        $dataItem = [
                            'pedido_id' => $pedido->id,
                            'nome_produto' => $it->name,
                            'image_url' => isset($it->imageUrl) ? $it->imageUrl : "",
                            'unidade' => $it->unit,
                            'valor_unitario' => $it->unitPrice,
                            'quantidade' => $it->quantity,
                            'total' => $it->totalPrice,
                            'valor_adicional' => $it->optionsPrice,
                            'observacao' => isset($it->observations) ? $it->observations : ""
                        ];
                        
                        $itemOrder = ItemPedidoIfood::create($dataItem);

                        //condicional de adicionais
                        if(isset($it->options)){
                            foreach($it->options as $op){
                                $dataAdicional = [
                                    'item_pedido_id' => $itemOrder->id,
                                    'nome' => $op->name,
                                    'unidade' => $op->unit,
                                    'quantidade' => $op->quantity,
                                    'valor_unitario' => $op->unitPrice,
                                    'total' => $op->price,
                                ];
                            }
                        }


                    }

                }
            }
            session()->flash('mensagem_sucesso', "Busca de novos pedidos realizada, $contNewOrders novo(s) pedidos foram encontrados!");
        }catch(\Exception $e){
            session()->flash('mensagem_erro', "Algo deu errado: " . $e->getMessage());
        }
        return redirect('/ifood/pedidos');
    }

    public function detail($id){
        $item = PedidoIfood::findOrFail($id);

        return view('pedido_ifood/detail', compact('item'))
        ->with('title', 'Detalhe do pedido #' . $item->id);
    }

    public function print($id){
        $item = PedidoIfood::findOrFail($id);

        $config = ConfigNota::
        where('empresa_id', $this->empresa_id)
        ->first();

        $p = view('pedido_ifood/print')
        ->with('config', $config)
        ->with('pedido', $item);
        // return $p;

        $domPdf = new Dompdf(["enable_remote" => true]);
        $domPdf->loadHtml($p);

        $pdf = ob_get_clean();

        $domPdf->setPaper("A4");
        $domPdf->render();
        $domPdf->stream("Pedido iFood $item->pedido_id.pdf");
    }

    public function getNewOrdersAsync(Request $request){
        try{
            $config = IfoodConfig::
            where('empresa_id', $this->empresa_id)
            ->first();

            $iFoodService = new IfoodService($config);

            $data = $iFoodService->getOrders("PLC");
            if($data == null){
                return response()->json("null", 200);
            }else{
                foreach($data as $item){

                    $pedido = PedidoIfood::where('pedido_id', $item->orderId)
                    ->first();

                    if($pedido == null){
                        $detail = $iFoodService->getOrderDetail($item->orderId);
                        if($detail){

                            $dataOrder = [
                                'status' => $item->code,
                                'pedido_id' => $item->orderId,
                                'data_pedido' => $item->createdAt,
                                'empresa_id' => $this->empresa_id
                            ];
                            $pedido = PedidoIfood::create($dataOrder);

                            $pedido->tipo_pedido = $detail->orderType;
                            if(isset($detail->delivery)){
                                $delivery = $detail->delivery->deliveryAddress;
                                $pedido->endereco = $delivery->formattedAddress;
                                $pedido->bairro = $delivery->neighborhood;
                                $pedido->cep = $delivery->postalCode;
                            }

                            if(isset($detail->customer)){
                                $customer = $detail->customer;

                                $pedido->nome_cliente = $customer->name;
                                $pedido->id_cliente = $customer->id;
                                $pedido->telefone_cliente = $customer->phone->number;
                                if(isset($customer->documentNumber)){
                                    $pedido->cpf_na_nota = $customer->documentNumber;
                                }
                            }

                            $pedido->valor_produtos = $detail->total->subTotal;
                            $pedido->valor_entrega = $detail->total->deliveryFee;
                            $pedido->valor_total = $detail->total->orderAmount;
                            $pedido->taxas_adicionais = $detail->total->additionalFees;

                            $pedido->save();

                            // $pedido->payments()->delete();
                            // $pedido->itens()->delete();
                            if(isset($detail->payments->methods)){
                                $methods = $detail->payments->methods;
                                foreach($methods as $m){
                                    $payData = [
                                        'forma_pagamento' => $m->method,
                                        'tipo_pagamento' => $m->type,
                                        'bandeira_cartao' => isset($m->card) ? $m->card->brand : '',
                                        'valor' => $m->value,
                                        'pedido_id' => $pedido->id
                                    ];

                                    PagamentoPedidoIfood::create($payData);
                                }
                            }

                            foreach($detail->items as $it){
                                $dataItem = [
                                    'pedido_id' => $pedido->id,
                                    'nome_produto' => $it->name,
                                    'image_url' => isset($it->imageUrl) ? $it->imageUrl : "",
                                    'unidade' => $it->unit,
                                    'valor_unitario' => $it->unitPrice,
                                    'quantidade' => $it->quantity,
                                    'total' => $it->totalPrice,
                                    'valor_adicional' => $it->optionsPrice,
                                    'observacao' => isset($it->observations) ? $it->observations : ""
                                ];

                                $itemOrder = ItemPedidoIfood::create($dataItem);

                                if(isset($it->options)){
                                    foreach($it->options as $op){
                                        $dataAdicional = [
                                            'item_pedido_id' => $itemOrder->id,
                                            'nome' => $op->name,
                                            'unidade' => $op->unit,
                                            'quantidade' => $op->quantity,
                                            'valor_unitario' => $op->unitPrice,
                                            'total' => $op->price,
                                        ];
                                    }
                                }

                            }

                        }
                    }
                }
            }

            $pedido = PedidoIfood::where('status_leitura', 0)
            ->where('status', 'PLC')
            ->orderBy('id', 'asc')
            ->with('itens')
            ->with('payments')
            ->first();

            if($pedido == null){
                return response()->json("", 200);
            }
            return view('pedido_ifood/novo_pedido', compact('pedido'));

        }catch(\Exception $e){
            return response()->json($e->getMessage(), 401);
        }
    }

    public function readOrder(Request $request){
        $pedido = PedidoIfood::findOrFail($request->pedido_id);

        $config = IfoodConfig::
        where('empresa_id', $this->empresa_id)
        ->first();

        $iFoodService = new IfoodService($config);
        if($request->status == 'CFM'){

            $dataStatus = $iFoodService->orderConfirm($pedido->pedido_id);

            // echo "<pre>";
            // print_r($dataStatus);
            // echo "</pre>";
            // die;
        }else{
            $dataStatus = $iFoodService->cancellation($pedido->pedido_id, $request->motivo);

            // echo "<pre>";
            // print_r($dataStatus);
            // echo "</pre>";
            // die;
        }

        if(isset($dataStatus->message)){

        }else{
            $pedido->status = $request->status;

            $pedido->status_leitura = true;
            $pedido->save();

            if($pedido->status == 'CFM'){
                session()->flash('mensagem_sucesso', 'Pedido lido e aprovado!');
            }else{
                session()->flash('mensagem_erro', 'Pedido lido e cancelado!');
            }
            return redirect('/ifood/pedidosDetail/'.$pedido->id);
        }
    }
}
