<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class BackupController extends Controller
{
    public function index(Request $request){

        $tables = $this->getTables($request->empresa_id);
        // echo "Total de tabelas: " . sizeof($tables);
        $return = "";
        foreach($tables as $table => $sql){

            try{
                $struture = DB::getSchemaBuilder()->getColumnListing($table);

                $fields = Schema::getColumnListing($table);

                $createSql = $this->createTableSql($table);

                $return .= "\n\n" . $createSql . ";\n\n";

                if($sql){
                    $result = DB::select($sql);

                    foreach($result as $r){
                        $array = json_decode(json_encode($r), true);
                        $return .= "INSERT INTO $table VALUES";
                        $return .= "(";
                        for ($i=0; $i < sizeof($fields); $i++) { 
                            
                            $return .= $this->retiraAcentos($array[$fields[$i]], $fields[$i]);

                            $return .= ($i < sizeof($fields)-1 ? ', ' : '');
                        }
                        $return .= ");";

                    }
                }

            }catch(\Exception $e){
                echo $e->getMessage();
            }

        }
        // die;
        $myfile = fopen("backup.sql", "w") or die("Unable to open file!");
        fwrite($myfile, $return);
        fclose($myfile);

        return response()->download("backup.sql");
        echo $return;
    }

    private function retiraAcentos($value, $field){
        if(in_array($field, $this->isColumnNull())){
            return 1;
        }
        return "'".str_replace("'", "", $value)."'";
    }

    private function getTables($empresa_id){
        // $tables = DB::select("show tables");
        $data = [
            'empresas' => "SELECT * FROM empresas WHERE id = $empresa_id",
            'usuarios' => "SELECT * FROM usuarios WHERE empresa_id = $empresa_id",
            'abertura_caixas' => "SELECT * FROM abertura_caixas WHERE empresa_id = $empresa_id",
            'cidades' => "SELECT * FROM cidades",
            'clientes' => "SELECT * FROM clientes WHERE empresa_id = $empresa_id",
            'categorias' => "SELECT * FROM categorias WHERE empresa_id = $empresa_id",
            'fornecedors' => "SELECT * FROM fornecedors WHERE empresa_id = $empresa_id",
            'natureza_operacaos' => "SELECT * FROM natureza_operacaos WHERE empresa_id = $empresa_id",
            'vendas' => "SELECT * FROM vendas WHERE empresa_id = $empresa_id",
            'item_vendas' => "SELECT * FROM item_vendas INNER JOIN vendas on vendas.id = item_vendas.venda_id WHERE empresa_id = $empresa_id",
        ];
        
        return $data;
    }

    private function createTableSql($table){
        $createSql = "SHOW CREATE TABLE $table;";

        $createSql = DB::select($createSql);
        if($createSql){
            foreach($createSql as $cr){
                foreach($cr as $key => $c){
                    if($key != 'Table') return $c;
                }
            }
        }
    }

    private function isColumnNull(){
        return [
            'cidade_cobranca_id'
        ];
    }


}

